/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SheetmetalTankBlockEntity
extends MultiblockPartBlockEntity<SheetmetalTankBlockEntity>
implements IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockBounds {
    public FluidTank tank = new FluidTank(512000);
    private final LayeredComparatorOutput comparatorHelper = new LayeredComparatorOutput(this.tank.getCapacity(), 4, () -> this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_()), layer -> {
        BlockPos masterPos = this.f_58858_.m_141950_((Vec3i)this.offsetToMaster);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos pos = masterPos.m_142082_(x, layer + 1, z);
                this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
            }
        }
    });
    private final Map<Direction, CapabilityReference<IFluidHandler>> fluidNeighbors = CapabilityReference.forAllNeighbors(this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    private static final BlockPos ioTopOffset = new BlockPos(1, 4, 1);
    private static final BlockPos ioBottomOffset = new BlockPos(1, 0, 1);
    private final MultiblockCapability<IFluidHandler> fluidInput = MultiblockCapability.make(this, be -> be.fluidInput, MultiblockPartBlockEntity::master, this.registerFluidInput(new IFluidTank[]{this.tank}));
    private final MultiblockCapability<IFluidHandler> fluidIO = MultiblockCapability.make(this, be -> be.fluidIO, MultiblockPartBlockEntity::master, this.registerFluidHandler(new IFluidTank[]{this.tank}));
    private AABB renderAABB;

    public SheetmetalTankBlockEntity(BlockEntityType<SheetmetalTankBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.SHEETMETAL_TANK, type, true, pos, state);
        this.redstoneControlInverted = true;
        this.fluidNeighbors.remove(Direction.UP);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.m_21120_(InteractionHand.MAIN_HAND))) {
            SheetmetalTankBlockEntity master = (SheetmetalTankBlockEntity)this.master();
            FluidStack fs = master != null ? master.tank.getFluid() : this.tank.getFluid();
            return new Component[]{TextUtils.formatFluidStack(fs)};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public void tickServer() {
        if (!this.isRSDisabled()) {
            for (CapabilityReference<IFluidHandler> outputRef : this.fluidNeighbors.values()) {
                int accepted;
                if (this.tank.getFluidAmount() <= 0) continue;
                int outSize = Math.min(1000, this.tank.getFluidAmount());
                FluidStack out = Utils.copyFluidStackWithAmount(this.tank.getFluid(), outSize, false);
                IFluidHandler output = outputRef.getNullable();
                if (output == null || (accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                this.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                this.markContainingBlockForUpdate(null);
            }
        }
        this.comparatorHelper.update(this.tank.getFluidAmount());
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.m_128469_("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
        nbt.m_128365_("tank", (Tag)tankTag);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (this.posInMultiblock.m_123341_() % 2 == 0 && this.posInMultiblock.m_123342_() == 0 && this.posInMultiblock.m_123343_() % 2 == 0) {
            return Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
        }
        return Shapes.m_83144_();
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (ioBottomOffset.equals((Object)this.posInMultiblock)) {
                return this.fluidIO.getAndCast();
            }
            if (ioTopOffset.equals((Object)this.posInMultiblock)) {
                return this.fluidInput.getAndCast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        SheetmetalTankBlockEntity master = (SheetmetalTankBlockEntity)this.master();
        if (master != null && FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)master.tank)) {
            this.updateMasterBlock(null, true);
            return true;
        }
        return false;
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offsetToMaster.equals((Object)BlockPos.f_121853_) ? new AABB(this.m_58899_().m_142082_(-1, 0, -1), this.m_58899_().m_142082_(2, 5, 2)) : new AABB(this.m_58899_(), this.m_58899_());
        }
        return this.renderAABB;
    }

    @Override
    public int getComparatorInputOverride() {
        if (ioBottomOffset.equals((Object)this.posInMultiblock)) {
            return this.comparatorHelper.getCurrentMasterOutput();
        }
        SheetmetalTankBlockEntity master = (SheetmetalTankBlockEntity)this.master();
        if (this.offsetToMaster.m_123342_() >= 1 && master != null) {
            return master.comparatorHelper.getLayerOutput(this.offsetToMaster.m_123342_() - 1);
        }
        return 0;
    }
}

